﻿
// ReimuIconDlg.cpp : 実装ファイル
//

#include "pch.h"
#include "framework.h"
#include "ReimuIcon.h"
#include "ReimuIconDlg.h"
#include "afxdialogex.h"
#include "CSettingDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// アプリケーションのバージョン情報に使われる CAboutDlg ダイアログ

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// ダイアログ データ
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_ABOUTBOX };
#endif

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV サポート

// 実装
protected:
	DECLARE_MESSAGE_MAP()
public:
//	virtual BOOL OnInitDialog();
//	afx_msg void OnBnClickedOk();
};

CAboutDlg::CAboutDlg() : CDialogEx(IDD_ABOUTBOX)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
//	ON_BN_CLICKED(IDOK, &CAboutDlg::OnBnClickedOk)
END_MESSAGE_MAP()


// CReimuIconDlg ダイアログ



CReimuIconDlg::CReimuIconDlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_REIMUICON_DIALOG, pParent)
	, m_iColNum(0)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_iBkColNum = 0;
}

void CReimuIconDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
//	DDX_Radio(pDX, IDC_RDO_BLACK, m_iColNum);
	DDX_Control(pDX, IDC_ST_REIMU, m_cReimuText);
}

BEGIN_MESSAGE_MAP(CReimuIconDlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_CTLCOLOR()
	ON_BN_CLICKED(IDC_BTN_COLSETTING, &CReimuIconDlg::OnClickedBtnColsetting)
END_MESSAGE_MAP()


// CReimuIconDlg メッセージ ハンドラー

BOOL CReimuIconDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// "バージョン情報..." メニューをシステム メニューに追加します。

	// IDM_ABOUTBOX は、システム コマンドの範囲内になければなりません。
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != nullptr)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// このダイアログのアイコンを設定します。アプリケーションのメイン ウィンドウがダイアログでない場合、
	//  Framework は、この設定を自動的に行います。
	SetIcon(m_hIcon, TRUE);			// 大きいアイコンの設定
	SetIcon(m_hIcon, FALSE);		// 小さいアイコンの設定

	// TODO: 初期化をここに追加します。
	this->m_iBkColNum = BK_GRAY;	// 背景色を灰色で初期化
	this->m_cBrushLightBlue.CreateSolidBrush(RGB(188,226,232));	// 水色ブラシを作成
	return TRUE;  // フォーカスをコントロールに設定した場合を除き、TRUE を返します。
}

void CReimuIconDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// ダイアログに最小化ボタンを追加する場合、アイコンを描画するための
//  下のコードが必要です。ドキュメント/ビュー モデルを使う MFC アプリケーションの場合、
//  これは、Framework によって自動的に設定されます。

void CReimuIconDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // 描画のデバイス コンテキスト

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// クライアントの四角形領域内の中央
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// アイコンの描画
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// ユーザーが最小化したウィンドウをドラッグしているときに表示するカーソルを取得するために、
//  システムがこの関数を呼び出します。
HCURSOR CReimuIconDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}



HBRUSH CReimuIconDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
	HBRUSH hbr = CDialogEx::OnCtlColor(pDC, pWnd, nCtlColor);

	// TODO: ここで DC の属性を変更してください。
	int id = pWnd->GetDlgCtrlID();
	if (id == IDC_ST_REIMU) {
		switch (m_iColNum) {
		case CReimuIconDlg::BLACK:
			pDC->SetTextColor(RGB(0, 0, 0));		// 黒
			break;
		case CReimuIconDlg::RED:
			pDC->SetTextColor(RGB(255, 0, 0));		// 赤
			break;
		case CReimuIconDlg::BLUE:
			pDC->SetTextColor(RGB(0, 0, 255));		// 青	
			break;
		case CReimuIconDlg::YELLOW:
			pDC->SetTextColor(RGB(255, 255, 0));	// 黄
			break;
		case CReimuIconDlg::GREEN:
			pDC->SetTextColor(RGB(0, 255, 0));		// 緑
			break;
		}
		pDC->SetBkMode(TRANSPARENT);				// 透過モードに設定
	}
	// TODO: 既定値を使用したくない場合は別のブラシを返します。
	if (m_iBkColNum == BK_WHITE) {
		return (HBRUSH)::GetStockObject(WHITE_BRUSH);
	}
	else if(m_iBkColNum == BK_BLACK) {
		return (HBRUSH)::GetStockObject(BLACK_BRUSH);
	}
	else if(m_iBkColNum == BK_GRAY) {
		return hbr;			// デフォルトのダイアログ背景色(灰色)
	}
	else {
		return this->m_cBrushLightBlue;				// 水色
	}
}


void CReimuIconDlg::OnClickedBtnColsetting()
{
	// TODO: ここにコントロール通知ハンドラー コードを追加します。
	CSettingDlg dlg;
	dlg.m_iColNum = this->m_iColNum;		// ダイアログに文字色初期値を設定
	dlg.m_iBkComNum = this->m_iBkColNum;	// ダイアログに背景色初期値を設定
	if (IDOK == dlg.DoModal()) {
		// OKでダイアログを閉じた場合
		this->m_iColNum = dlg.m_iColNum;	// ダイアログの文字色設定状態を取得する
		this->m_iBkColNum = dlg.m_iBkComNum;// ダイアログの背景色設定状態を取得する
		//this->m_cReimuText.Invalidate();	// 霊夢テキストを再描画する
		this->Invalidate();					// 画面全体を再描画する
	}
}
